# Extra_ggplot
# Purpose: Get to know the package ggplot2
# by Tiziana Li Koch

#install.packages("ggplot2")
library(ggplot2)

# Load data
plot_data <- read.csv("Data/vegetation_survey_fogo.csv")


ggplot(data = plot_data, aes(x = Tree_cover, y = Elevation_gps))

ggplot(data = plot_data, aes(x = Tree_cover, y = Elevation_gps)) +
  geom_point()

ggplot(data = plot_data, aes(x = Tree_cover, y = Elevation_gps)) + 
  geom_point() +
  geom_smooth(method = "lm") 

ggplot(data = plot_data, aes(x = Tree_cover, y = Elevation_gps, 
                             col = Inclination)) + 
  geom_point()



ggplot(data = plot_data, aes(x = Tree_cover)) + 
  geom_histogram(bins = 10) +
  facet_wrap(~year, nrow = 2)


ggplot(data = plot_data, aes(x = Tree_cover)) + 
  geom_histogram(bins = 10) +
  facet_wrap(~year, nrow = 1, ncol = 2)


# saving plots as object
plot1 <- ggplot(data = plot_data, aes(x = Tree_cover, y = Elevation_gps)) + 
  geom_point() +
  geom_smooth(method = "lm") 

plot1 + geom_smooth(method = "lm", col = "red") 

ggsave("Data/new_plot.png")



# Cheatsheet
# https://www.maths.usyd.edu.au/u/UG/SM/STAT3022/r/current/Misc/data-visualization-2.1.pdf

# Inspiration
# https://r-graph-gallery.com/index.html